PROC TABULATE DATA=ghpb20 MISSING NOSEPS;  
 
CLASS contract_num_HEALTH INS3 ent3 filingsize / PRELOADFMT;
title 'Table B2. Distribution of Group health Plans';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2020';
title3 'All Plans';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. contract_num_HEALTH=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';
RUN;

PROC TABULATE DATA=ghpb20 MISSING NOSEPS;                                                                                                                                                      
Where filingsize='1';
CLASS contract_num_HEALTH INS3 ent3 filingsize / PRELOADFMT;
title 'Table B2. Distribution of Group health Plans';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2020';
title3 'Plans with 100 or More Participants and Trusts';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. contract_num_HEALTH=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';
RUN;

PROC TABULATE DATA=ghpb20 MISSING NOSEPS;                                                                                                                                                      
Where filingsize='2';
CLASS contract_num_HEALTH INS3 ent3 filingsize / PRELOADFMT;
title 'Table B2. Distribution of Group health Plans';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2020';
title3 'Plans with 100 or More Participants and No Trusts';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. contract_num_HEALTH=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';
RUN;

PROC TABULATE DATA=ghpb20 MISSING NOSEPS;                                                                                                                                                      
Where filingsize='3';
CLASS contract_num_HEALTH INS3 ent3 filingsize / PRELOADFMT;
title 'Table B2. Distribution of Group health Plans';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2020';
title3 'Plans with Fewer Than 100 Participants and Trusts';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. contract_num_HEALTH=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';
RUN;
